package app.firezone.synk.network.Fragments;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.ValueEventListener;
import app.firezone.synk.network.Adapter.LudoMatchAdapter;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.FragmentLudoUpcomingBinding;
import app.firezone.synk.network.model.Match_Model;

import java.util.ArrayList;


public class LudoUpcomingFragment extends Fragment {

    FragmentLudoUpcomingBinding binding;

    ArrayList<Match_Model> mlist = new ArrayList<>();

    LudoMatchAdapter mAdapter;

    Dialog dialog;


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        binding =  FragmentLudoUpcomingBinding.inflate(inflater, container, false);
        View view = binding.getRoot();


        dialog = new Dialog(getContext());
        dialog.setContentView(R.layout.loading_dialog);


        if (dialog.getWindow() !=null){

            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(true);
        }


        dialog.show();

        binding.ludoRecy.setLayoutManager(new LinearLayoutManager(getContext()));
        mlist.clear();


        FirebaseDatabase.getInstance().getReference().child("New Match").child("Upcoming Match").child("LUDO")
                .addListenerForSingleValueEvent(new ValueEventListener() {
                    @Override
                    public void onDataChange(@NonNull DataSnapshot snapshot) {
                        for (DataSnapshot snapshot1: snapshot.getChildren()){
                            Match_Model match_model = snapshot1.getValue(Match_Model.class);
                            dialog.dismiss();
                            mlist.add(match_model);

                        }

                        mAdapter = new LudoMatchAdapter(getContext(), mlist);
                        binding.ludoRecy.setAdapter(mAdapter);
                    }

                    @Override
                    public void onCancelled(@NonNull DatabaseError error) {
                        dialog.dismiss();
                        Toast.makeText(getContext(), "Error: " +error.getMessage(), Toast.LENGTH_SHORT).show();

                    }
                });



        return view;
    }
}